package ru.yandex.webmaster3.worker.searchquery;

import ru.yandex.webmaster3.storage.util.yt.YtException;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoad;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * Задача автоматического импорта групп поисковых запросов
 * Created by Oleg Bazdyrev on 11/04/2017.
 */
public class SearchQueriesImportGroupTask extends AbstractSearchQueryImportTask {

    protected YtClickhouseDataLoad init(YtClickhouseDataLoad latestImport) throws InterruptedException, YtException {
        return initGroupsByTableName(latestImport);
    }

    @Override
    protected YtClickhouseDataLoad prepare(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.prepareGroups(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad doImport(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.importGroups(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad replicate(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.replicateGroups(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad rename(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.renameGroup(imprt).withNextState();
    }

    public YtClickhouseDataLoadType getImportType() {
        return YtClickhouseDataLoadType.GROUP;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 0/5 * * * *");
    }
}
