package ru.yandex.webmaster3.worker.searchquery;

import java.util.Collection;
import java.util.List;

import org.joda.time.LocalDate;

import ru.yandex.webmaster3.storage.searchquery.SearchQueriesConstants;
import ru.yandex.webmaster3.storage.searchquery.importing.QueryTablesDefinitions;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoad;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * Created by Oleg Bazdyrev on 11/04/2017.
 */
public class SearchQueriesImportTopQueriesTask extends AbstractSearchQueryImportTask {

    @Override
    protected YtClickhouseDataLoad prepare(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.prepareTopQueries(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad doImport(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.importTopQueries(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad replicate(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.replicateTopQueries(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad rename(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.renameTop(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoadType getImportType() {
        return YtClickhouseDataLoadType.TOP;
    }

    @Override
    protected YtClickhouseDataLoad createDistributedTables(YtClickhouseDataLoad imprt) throws Exception {
        LocalDate date = imprt.getDateTo();
        String dateString = SearchQueriesConstants.IN_TABLE_NAME_DATE_FORMATTER.print(date);
        QueryTablesDefinitions.MDB_TOP_QUERIES_TEXTS_TABLE.updateDistributedSymlink(clickhouseServer, dateString);
        QueryTablesDefinitions.MDB_TOP_QUERIES_VALUES_TABLE.updateDistributedSymlink(clickhouseServer, dateString);
        return imprt.withNextState();
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 25 * * * *");
    }

}
