package ru.yandex.webmaster3.worker.searchquery;

import ru.yandex.webmaster3.storage.searchquery.SearchQueriesConstants;
import ru.yandex.webmaster3.storage.searchquery.importing.QueryTablesDefinitions;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoad;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * Created by Oleg Bazdyrev on 12/04/2017.
 */
public class SearchQueriesImportWeekTask extends AbstractSearchQueryImportTask {

    @Override
    protected YtClickhouseDataLoad prepare(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.prepareWeek(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad doImport(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.importWeek(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad replicate(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.replicateWeek(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad rename(YtClickhouseDataLoad imprt) throws Exception {
        return queriesImportService.renameWeek(imprt).withNextState();
    }

    @Override
    protected YtClickhouseDataLoad createDistributedTables(YtClickhouseDataLoad imprt) throws Exception {
        QueryTablesDefinitions.MDB_WEEK_TABLE.updateDistributedSymlink(clickhouseServer,
                SearchQueriesConstants.IN_TABLE_NAME_DATE_FORMATTER.print(imprt.getDateFrom()),
                SearchQueriesConstants.IN_TABLE_NAME_DATE_FORMATTER.print(imprt.getDateTo()));
        return imprt.withNextState();
    }

    @Override
    protected YtClickhouseDataLoadType getImportType() {
        return YtClickhouseDataLoadType.WEEK;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 30 * * * *");
    }

}
