package ru.yandex.webmaster3.worker.searchurl;

import org.joda.time.Instant;

import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportInfo;
import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportTaskType;
import ru.yandex.webmaster3.storage.searchurl.samples.dao.ExcludedUrlSampleTablesUtil;

/**
 * @author avhaliullin
 */
public class ImportExcludedUrlSamplesTask extends AbstractSearchBaseImportTask {
    public ImportExcludedUrlSamplesTask() {
        super(
                SearchBaseImportTaskType.EXCLUDED_URL_SAMPLES,
                ExcludedUrlSampleTablesUtil.DB_NAME,
                ExcludedUrlSampleTablesUtil.EXCLUDED_TABLE_INSERT_SPEC
        );
    }

    @Override
    protected String distributedTableName(Instant searchBaseDate) {
        return ExcludedUrlSampleTablesUtil.excludedUrlsDistributedTableName(searchBaseDate);
    }

    @Override
    protected String partTableName(Instant searchBaseDate, int part) {
        return ExcludedUrlSampleTablesUtil.excludedUrlsPartTableName(searchBaseDate, part);
    }

    @Override
    protected String partTableCreateSpec(Instant searchBaseDate, int part) {
        return ExcludedUrlSampleTablesUtil.excludedUrlsTableCreateSpec(searchBaseDate, part);
    }

    @Override
    protected String shardTableCreateQuery(SearchBaseImportInfo importInfo) {
        return ExcludedUrlSampleTablesUtil.excludedUrlsShardCreateQuery(importInfo);
    }

    @Override
    protected String distributedTableCreateQuery(SearchBaseImportInfo importInfo) {
        return ExcludedUrlSampleTablesUtil.excludedUrlsDistributedCreateQuery(importInfo);
    }

    @Override
    protected String symlinkTableDropQuery(SearchBaseImportInfo importInfo) {
        return ExcludedUrlSampleTablesUtil.excludedUrlsDropSymlinkQuery();
    }

    @Override
    protected String symlinkTableCreateQuery(SearchBaseImportInfo importInfo) {
        return ExcludedUrlSampleTablesUtil.excludedUrlsCreateSymlinkQuery(importInfo);
    }
}
