package ru.yandex.webmaster3.worker.searchurl;

import org.joda.time.Instant;

import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportInfo;
import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportTaskType;
import ru.yandex.webmaster3.storage.searchurl.samples.dao.SearchUrlEventSampleTablesUtil;

/**
 * @author avhaliullin
 */
public class ImportSearchUrlEventSamplesTask extends AbstractSearchBaseImportTask {
    public ImportSearchUrlEventSamplesTask() {
        super(
                SearchBaseImportTaskType.SEARCH_URL_EVENT_SAMPLES,
                SearchUrlEventSampleTablesUtil.DB_NAME,
                SearchUrlEventSampleTablesUtil.EVENTS_TABLE_INSERT_SPEC
        );
    }

    @Override
    protected String distributedTableName(Instant searchBaseDate) {
        return SearchUrlEventSampleTablesUtil.eventsDistributedTableName(searchBaseDate);
    }

    @Override
    protected String partTableName(Instant searchBaseDate, int part) {
        return SearchUrlEventSampleTablesUtil.eventsPartTableName(searchBaseDate, part);
    }

    @Override
    protected String partTableCreateSpec(Instant searchBaseDate, int part) {
        return SearchUrlEventSampleTablesUtil.eventsTableCreateSpec(searchBaseDate, part);
    }

    @Override
    protected String shardTableCreateQuery(SearchBaseImportInfo importInfo) {
        return SearchUrlEventSampleTablesUtil.eventsShardCreateQuery(importInfo);
    }

    @Override
    protected String distributedTableCreateQuery(SearchBaseImportInfo importInfo) {
        return SearchUrlEventSampleTablesUtil.eventsDistributedCreateQuery(importInfo);
    }

    @Override
    protected String symlinkTableDropQuery(SearchBaseImportInfo importInfo) {
        return SearchUrlEventSampleTablesUtil.eventsDropSymlinkQuery();
    }

    @Override
    protected String symlinkTableCreateQuery(SearchBaseImportInfo importInfo) {
        return SearchUrlEventSampleTablesUtil.eventsCreateSymlinkQuery(importInfo);
    }
}
