package ru.yandex.webmaster3.worker.searchurl;

import org.joda.time.Instant;

import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportInfo;
import ru.yandex.webmaster3.storage.searchurl.offline.data.SearchBaseImportTaskType;
import ru.yandex.webmaster3.storage.searchurl.samples.dao.SearchUrlSampleTablesUtil;

/**
 * @author avhaliullin
 */
public class ImportSearchUrlSamplesTask extends AbstractSearchBaseImportTask {
    public ImportSearchUrlSamplesTask() {
        super(
                SearchBaseImportTaskType.SEARCH_URL_SAMPLES,
                SearchUrlSampleTablesUtil.DB_NAME,
                SearchUrlSampleTablesUtil.URL_TABLE_INSERT_SPEC
        );
    }

    @Override
    protected String distributedTableName(Instant searchBaseDate) {
        return SearchUrlSampleTablesUtil.urlsDistributedTableName(searchBaseDate);
    }

    @Override
    protected String partTableName(Instant searchBaseDate, int part) {
        return SearchUrlSampleTablesUtil.urlsPartTableName(searchBaseDate, part);
    }

    @Override
    protected String partTableCreateSpec(Instant searchBaseDate, int part) {
        return SearchUrlSampleTablesUtil.urlsTableCreateSpec(searchBaseDate, part);
    }

    @Override
    protected String shardTableCreateQuery(SearchBaseImportInfo importInfo) {
        return SearchUrlSampleTablesUtil.urlsShardCreateQuery(importInfo);
    }

    @Override
    protected String distributedTableCreateQuery(SearchBaseImportInfo importInfo) {
        return SearchUrlSampleTablesUtil.urlsDistributedCreateQuery(importInfo);
    }

    @Override
    protected String symlinkTableDropQuery(SearchBaseImportInfo importInfo) {
        return SearchUrlSampleTablesUtil.urlsDropSymlinkQuery();
    }

    @Override
    protected String symlinkTableCreateQuery(SearchBaseImportInfo importInfo) {
        return SearchUrlSampleTablesUtil.urlsCreateSymlinkQuery(importInfo);
    }
}
