package ru.yandex.webmaster3.worker.serplinks;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * @author avhaliullin
 */
public class HostChangeEntry {
    private String host;
    private List<SectionChange> changes;

    public String getHost() {
        return host;
    }

    @JsonProperty(required = true)
    public void setHost(String host) {
        this.host = host;
    }

    public List<SectionChange> getChanges() {
        return changes;
    }

    @JsonProperty(required = true)
    public void setChanges(List<SectionChange> changes) {
        this.changes = changes;
    }

    public static class SectionChange {
        private String section;
        private boolean positionsChanged;
        private List<String> newPages;
        private List<String> removedPages;
        private List<PageNamesChange> newNames;

        public String getSection() {
            return section;
        }

        @JsonProperty(required = true)
        public void setSection(String section) {
            this.section = section;
        }

        public boolean isPositionsChanged() {
            return positionsChanged;
        }

        public void setPositionsChanged(boolean positionsChanged) {
            this.positionsChanged = positionsChanged;
        }

        public List<String> getNewPages() {
            return newPages;
        }

        public void setNewPages(List<String> newPages) {
            this.newPages = newPages;
        }

        public List<String> getRemovedPages() {
            return removedPages;
        }

        public void setRemovedPages(List<String> removedPages) {
            this.removedPages = removedPages;
        }

        public List<PageNamesChange> getNewNames() {
            return newNames;
        }

        public void setNewNames(List<PageNamesChange> newNames) {
            this.newNames = newNames;
        }
    }

    public static class PageNamesChange {
        private String page;
        private List<String> names;

        @JsonProperty(required = true)
        public void setPage(String page) {
            this.page = page;
        }

        @JsonProperty(required = true)
        public void setNames(List<String> names) {
            this.names = names;
        }

        public String getPage() {
            return page;
        }

        public List<String> getNames() {
            return names;
        }
    }

}
