package ru.yandex.webmaster3.worker.serplinks;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.worker.client.WorkerClient;
import ru.yandex.webmaster3.core.worker.task.InitializeHostTaskData;
import ru.yandex.webmaster3.core.worker.task.SerpLinksCheckerTaskData;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.worker.Task;

/**
 * @author avhaliullin
 */
@Component("initializeHostTask")
public class InitializeHostTask extends Task<InitializeHostTaskData> {
    private WorkerClient workerClient;

    public InitializeHostTask(@Qualifier("lbWorkerClient") WorkerClient workerClient) {
        this.workerClient = workerClient;
    }

    @Override
    public Result run(InitializeHostTaskData data) throws Exception {
        workerClient.enqueueTask(new SerpLinksCheckerTaskData(data.getHostId()));
        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public Class<InitializeHostTaskData> getDataClass() {
        return InitializeHostTaskData.class;
    }

}
