package ru.yandex.webmaster3.worker.sitemap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.worker.task.SitemapRecrawlTaskData;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.worker.Task;
import ru.yandex.webmaster3.worker.url.checker2.UrlCheckProcessYtRequestsTask;

/**
 * Created by leonidrom on 23/05/2017.
 */
public class SitemapRecrawlTask extends Task<SitemapRecrawlTaskData> {
    private static final Logger log = LoggerFactory.getLogger(SitemapRecrawlTask.class);

    private SitemapRecrawlService sitemapRecrawlService;

    @Override
    public Result run(SitemapRecrawlTaskData data) throws Exception {
        sitemapRecrawlService.recrawlSitemap(data.getSitemapUrl());
        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public Class<SitemapRecrawlTaskData> getDataClass() {
        return SitemapRecrawlTaskData.class;
    }

    @Required
    public void setSitemapRecrawlService(SitemapRecrawlService sitemapRecrawlService) {
        this.sitemapRecrawlService = sitemapRecrawlService;
    }
}