package ru.yandex.webmaster3.worker.turbo;

import ru.yandex.webmaster3.storage.clickhouse.TableType;
import ru.yandex.webmaster3.storage.turbo.dao.statistics.TurboSearchUrlsStatsCHDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHTable;
import ru.yandex.webmaster3.storage.yql.YqlQueryBuilder;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoad;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;
import ru.yandex.webmaster3.worker.TaskSchedule;

import static ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType.TURBO_SEARCHURLS_STATS;

public class ImportTurboSearchUrlsStatsTask extends AbstractYqlPrepareImportTask {

    private int rowCount = 256;

    @Override
    protected CHTable getTable() {
        return TurboSearchUrlsStatsCHDao.SEARCHURLS_STATS_TABLE;
    }

    @Override
    protected TableType getTableType() {
        return TableType.TURBO_SEARCHURLS_STATS;
    }

    @Override
    protected YqlQueryBuilder prepareIntermediateTable(YtClickhouseDataLoad imprt) {

        String dateString = IN_YQL_QUERY_DATE_FORMATTER.print(imprt.getDateTo());

        YqlQueryBuilder yqlQueryBuilder = YqlQueryBuilder.newBuilder()
                .cluster(tablePath)
                .appendText("PRAGMA yt.MaxRowWeight = '128M';")
                .appendText("INSERT INTO " + INTERMEDIATE_TABLE)
                .appendText("SELECT ShardId, RowId, Compress::Gzip(String::JoinFromList(AGGREGATE_LIST(data), ''), 6) as data FROM (")
                .appendText("SELECT")
                .appendText("(Digest::Fnv64(Domain) % " + getShardsCount() + ") as ShardId,")
                .appendText("((Digest::Fnv64(Domain) / " + getShardsCount() + ") % " + rowCount + ") as RowId,")
                .appendText("(")
                .appendText("'" + dateString + "'")
                .appendText("|| '\\t' || Domain ")
                .appendText("|| '\\t' || CAST(TurboUrls as String) ")
                .appendText("|| '\\t' || CAST(TurboSearchUrls as String) ")
                .appendText("|| '\\t' || CAST(TurboSearchUrlsNoAP as String) ")
                .appendText("|| '\\t' || CAST(AutoparsedUrls as String) ")
                .appendText("|| '\\t' || CAST(AutoparsedButtonUrls as String) ")
                .appendText("|| '\\t' || CAST(RssUrls as String) ")
                .appendText("|| '\\t' || CAST(YmlUrls as String) ")
                .appendText("|| '\\t' || CAST(ApiUrls as String) ")
                .appendText("|| '\\t' || CAST(YmlListingUrls as String) ")
                .appendText("|| '\\t' || CAST(AutoMordaUrls as String) ")
                .appendText("|| '\\n') as data")
                .appendText("FROM")
                .appendTable(tablePath)
                .appendText(") GROUP BY ShardId, RowId;")
                .appendText("COMMIT;");

        return yqlQueryBuilder;
    }

    @Override
    protected int getShardsCount() {
        return 1;
    }

    @Override
    protected YtClickhouseDataLoadType getImportType() {
        return TURBO_SEARCHURLS_STATS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 50 * * * *");
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }
}
