package ru.yandex.webmaster3.worker.turbo;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.worker.task.TurboAdv4BoxTaskData;
import ru.yandex.webmaster3.storage.turbo.service.adv.TurboAutoAdvService;
import ru.yandex.webmaster3.worker.Task;

/**
 * ishalaru
 * 18.12.2020
 **/
@Service
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Slf4j
public class InitTurboAdv4BoxTask extends Task<TurboAdv4BoxTaskData> {
    private final TurboAutoAdvService turboAutoAdvService;

    @Override
    public Result run(TurboAdv4BoxTaskData data) throws Exception {
        try {
            turboAutoAdvService.initTurboAutoAdvBlocks(String.valueOf(data.getUserId()), data.getHostId());
        } catch (Exception exp) {
            log.error(exp.getMessage(), exp);
            turboAutoAdvService.resetStatus(data.getHostId());
            return Result.FAIL;
        }
        return Result.SUCCESS;

    }

    @Override
    public Class<TurboAdv4BoxTaskData> getDataClass() {
        return TurboAdv4BoxTaskData.class;
    }
}
