package ru.yandex.webmaster3.worker.turbo;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.blackbox.UserWithLogin;
import ru.yandex.webmaster3.core.blackbox.service.BlackboxUsersService;
import ru.yandex.webmaster3.core.checklist.data.SiteProblemSeverityEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.core.notification.UTMLabels;
import ru.yandex.webmaster3.core.turbo.adv.AutoAdvUserVerifyTaskData;
import ru.yandex.webmaster3.core.util.TimeUtils;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.notifications.service.EmailSenderService;
import ru.yandex.webmaster3.tanker.I18nEmailCommons;
import ru.yandex.webmaster3.tanker.I18nEmailSeverityStatus;
import ru.yandex.webmaster3.tanker.I18nPostWelcomeEmail;
import ru.yandex.webmaster3.worker.Task;
import ru.yandex.webmaster3.worker.notifications.auto.NotificationsTemplateUtil;

/**
 * ishalaru
 * 09.09.2020
 **/
@Service
@Slf4j
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class SendAutoAdvVerifyUserEmailTask extends Task<AutoAdvUserVerifyTaskData> {
    private final EmailSenderService emailSenderService;
    private final BlackboxUsersService blackboxUsersService;

    @Override
    public Result run(AutoAdvUserVerifyTaskData data) throws Exception {
        final String email = data.getEmail();
        final UserWithLogin mainUser = blackboxUsersService.getUserById(data.getUserId());
        StringBuilder strBuilder = new StringBuilder();
        UTMLabels utmLabels = UTMLabels.createEmail("turbo_auto_adv", LocalDate.now(TimeUtils.EUROPE_MOSCOW_ZONE), null);
        String login = email.substring(0, email.indexOf("@"));
        makeMessageBody(strBuilder, utmLabels, data.getHostId(), mainUser.getLogin(), login, makeQueryParam(WwwUtil.cutWWWAndM(data.getHostId().getPunycodeHostname()), data.getEmail(), data.getKey()));
        String subject = makeMessageSubject(utmLabels, mainUser.getLogin());
        emailSenderService.sendEmail(email, email, subject, strBuilder.toString());
        log.info("Send ");
        return Result.SUCCESS;
    }


    public String makeQueryParam(String domain, String email, String key) {
        StringBuilder str = new StringBuilder("domain=").append(domain);
        str.append("&email=").append(email);
        str.append("&key=").append(key);
        return str.toString();
    }

    public void makeMessageBody(StringBuilder body, UTMLabels utmLabels, WebmasterHostId hostId, String mainLogin, String login, String queryParam) {
        String domain = WwwUtil.cutWWWAndM(hostId.getPunycodeHostname());
        I18nEmailCommons.HEADER
                .newBuilder(LanguageEnum.RU)
                .utm(utmLabels)
                .headerLogo(NotificationsTemplateUtil.headerLogo.get(LanguageEnum.RU))
                .headerIcon(NotificationsTemplateUtil.HEADER_ICON)
                .darkHeaderLogo(NotificationsTemplateUtil.headerDarkLogo.get(LanguageEnum.R))
                .darkHeaderIcon(NotificationsTemplateUtil.HEADER_DARK_ICON)
                .mainPageLink(NotificationsTemplateUtil.DEFAULT_MAIN_PAGE_LINK + utmLabels.getLabelsInQuery())
                .renderTo(body);

        I18nEmailSeverityStatus.fromEnum(SiteProblemSeverityEnum.RECOMMENDATION)
                .createRenderableText(LanguageEnum.RU)
                .renderTo(body);
        I18nPostWelcomeEmail.TURBO_AUTO_ADV_TMP_body
                .newBuilder(LanguageEnum.RU)
                .utm(utmLabels)
                .host(hostId.getPunycodeHostname())
                .hostId(hostId.toString())
                .domain(domain)
                .login(login)
                .mainLogin(mainLogin)
                .queryParam(queryParam)
                .renderTo(body);
        I18nPostWelcomeEmail.FOOTER_WITHOUT_UNSUBSCRIBE
                .newBuilder(LanguageEnum.RU)
                .utm(utmLabels)
                .host(hostId.toString())
                .hostId(hostId.toString())
                .year(String.valueOf(LocalDate.now().getYear()))
                .renderTo(body);
    }

    public String makeMessageSubject(UTMLabels utmLabels, String login) {
        return I18nPostWelcomeEmail.TURBO_AUTO_ADV_TMP_subject
                .newBuilder(LanguageEnum.RU)
                .utm(utmLabels)
                .host("host")
                .hostId("host")
                .login(login)
                .render();
    }

    @Override
    public Class getDataClass() {
        return AutoAdvUserVerifyTaskData.class;
    }
}
