package ru.yandex.webmaster3.worker.turbo.autodelete;

import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.storage.clickhouse.TableType;
import ru.yandex.webmaster3.storage.turbo.dao.autodelete.TurboAutoDeletedPagesCHDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.CHTable;
import ru.yandex.webmaster3.storage.yql.YqlQueryBuilder;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoad;
import ru.yandex.webmaster3.storage.ytimport.YtClickhouseDataLoadType;
import ru.yandex.webmaster3.worker.TaskSchedule;
import ru.yandex.webmaster3.worker.turbo.AbstractYqlPrepareImportTask;

/**
 * Created by Oleg Bazdyrev on 19/02/2021.
 */
public class ImportTurboAutoDeletedPagesTask extends AbstractYqlPrepareImportTask {

    private static final int ROW_COUNT = 256;

    @Override
    protected YqlQueryBuilder prepareIntermediateTable(YtClickhouseDataLoad imprt) {
        String dateString = IN_YQL_QUERY_DATE_FORMATTER.print(imprt.getDateTo());

        YqlQueryBuilder yqlQueryBuilder = YqlQueryBuilder.newBuilder()
                .cluster(tablePath)
                .inferSchema(YqlQueryBuilder.InferSchemaMode.INFER)
                .appendText("PRAGMA yt.MaxRowWeight = '128M';")
                .appendText("INSERT INTO " + INTERMEDIATE_TABLE)
                .appendText("SELECT ShardId, RowId, Compress::Gzip(String::JoinFromList(AGGREGATE_LIST(data), ''), 6) as data FROM (")
                .appendText("SELECT")
                .appendText("(Digest::Fnv64(host) % " + getShardsCount() + ") as ShardId,")
                .appendText("((Digest::Fnv64(url)) % " + ROW_COUNT + ") as RowId,")
                .appendText("('" + dateString + "'")
                .appendText("|| '\\t' || host")
                .appendText("|| '\\t' || String::EscapeC(url)")
                .appendText("|| '\\n') as data")
                .appendText("FROM")
                .appendTable(tablePath)
                .appendText(") GROUP BY ShardId, RowId;")
                .appendText("COMMIT;");

        return yqlQueryBuilder;
    }

    @Override
    protected CHTable getTable() {
        return TurboAutoDeletedPagesCHDao.TABLE;
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.IMPORT_TURBO_AUTO_DELETED_PAGES;
    }

    @Override
    protected YtClickhouseDataLoadType getImportType() {
        return YtClickhouseDataLoadType.TURBO_AUTO_DELETED_PAGES;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 22 * * * *");
    }

    @Override
    protected TableType getTableType() {
        return TableType.TURBO_AUTO_DELETED_PAGES;
    }


}
