package ru.yandex.webmaster3.worker.turbo.bans;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.checklist.dao.TurboHostBanRecheckQueueYDao;
import ru.yandex.webmaster3.storage.util.yt.YtColumn;
import ru.yandex.webmaster3.storage.util.yt.YtException;
import ru.yandex.webmaster3.storage.util.yt.YtNode;
import ru.yandex.webmaster3.storage.util.yt.YtNodeAttributes;
import ru.yandex.webmaster3.storage.util.yt.YtPath;
import ru.yandex.webmaster3.storage.util.yt.YtSchema;
import ru.yandex.webmaster3.storage.util.yt.YtService;
import ru.yandex.webmaster3.storage.util.yt.YtTableData;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * Created by Oleg Bazdyrev on 20/11/2018.
 */
@Service
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class ExportTurboHostBansRechecksTask extends PeriodicTask<PeriodicTaskState> {

    private final TurboHostBanRecheckQueueYDao turboHostBanRecheckQueueYDao;
    private final YtService ytService;
    @Value("${webmaster3.worker.turbo.exportHostBansRecheckes.path}")
    private YtPath tablePath;

    private interface F {
        YtSchema TABLE_SCHEMA = new YtSchema();
        YtColumn<String> HOST = TABLE_SCHEMA.addColumn("Host", YtColumn.Type.STRING);
        YtColumn<Long> TIMESTAMP = TABLE_SCHEMA.addColumn("Timestamp", YtColumn.Type.INT_64);
    }

    @Override
    public Result run(UUID runId) throws Exception {
        YtTableData tableData = ytService.prepareTableData(tablePath.getName(), tableWriter -> {
            turboHostBanRecheckQueueYDao.forEach(recheckRecord -> {
                F.HOST.set(tableWriter, recheckRecord.getHostId().getPunycodeHostname());
                F.TIMESTAMP.set(tableWriter, recheckRecord.getDate().getMillis());
                try {
                    tableWriter.rowEnd();
                } catch (YtException e) {
                    throw new WebmasterException("YT error",
                            new WebmasterErrorResponse.YTServiceErrorResponse(getClass(), e), e);
                }
            });

        });

        ytService.inTransaction(tablePath).execute(cypressService -> {
            YtNodeAttributes attributes = new YtNodeAttributes().setSchema(F.TABLE_SCHEMA);
            cypressService.create(tablePath, YtNode.NodeType.TABLE, true, attributes, true);
            cypressService.writeTable(tablePath, tableData);
            return true;
        });
        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.EXPORT_TURBO_HOST_BANS_RECHECKS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 15 3/6 * * *");
    }
}
