package ru.yandex.webmaster3.worker.turbo.event;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.webmaster3.storage.events.data.WMCEvent;
import ru.yandex.webmaster3.storage.events.data.events.TurboSettingsChangeEvent;
import ru.yandex.webmaster3.storage.events.service.WMCEventsObserver;

/**
 * Created by Oleg Bazdyrev on 07/02/2019.
 */
public class TurboSettingsChangeEventObserver implements WMCEventsObserver {

    private static final Logger log = LoggerFactory.getLogger(TurboSettingsChangeEventObserver.class);

    @Override
    public boolean observe(WMCEvent event) {
        log.info("Observing turbo settings change for domain {}",
                ((TurboSettingsChangeEvent) event.getContent()).getDomain());
        // do nothing, just logging to LB
        return true;
    }

    @Override
    public boolean isProcessedLoggingEnabled() {
        return true;
    }
}
