package ru.yandex.webmaster3.worker.url.checker2;

/**
 * Created by leonidrom on 06/03/2017.
 */

import java.util.UUID;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.url.checker2.UrlCheckService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * Периодическая таска, которая выгребает накопившиеся запросы к Yt
 * и запускает процесс проверки URL через Yt
 */
public class UrlCheckProcessYtRequestsTask extends PeriodicTask<PeriodicTaskState> {
    private static final Logger log = LoggerFactory.getLogger(UrlCheckProcessYtRequestsTask.class);

    private UrlCheckService urlCheckService;

    @Override
    public Result run(UUID runId) throws Exception {
        TaskState ts = new TaskState();
        setState(ts);

        ts.totalRequests = urlCheckService.processYtRequests();

        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.URL_CHECK_PROCESS_YT_REQUESTS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 */5 * * * *");
//         return TaskSchedule.never();
    }

    @Required
    public void setUrlCheckService(UrlCheckService urlCheckService) {
        this.urlCheckService = urlCheckService;
    }

    public class TaskState implements PeriodicTaskState {
        int totalRequests;

        public int getTotalRequests() {
            return totalRequests;
        }
    }
}
