package ru.yandex.webmaster3.worker.url.checker2;

/**
 * Created by leonidrom on 06/03/2017.
 */

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.url.checker2.UrlCheckService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

import java.util.UUID;

/**
 * Периодическая таска, которая перекладывает полученные от Yt результаты в наши таблички
 */
public class UrlCheckProcessYtResultsTask extends PeriodicTask<PeriodicTaskState> {
    private static final Logger log = LoggerFactory.getLogger(UrlCheckProcessYtResultsTask.class);

    private UrlCheckService urlCheckService;

    @Override
    public Result run(UUID runId) throws Exception {
        urlCheckService.processYtResults();

        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.URL_CHECK_PROCESS_YT_RESULTS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.startByCron("0 */1 * * * *");
    }

    @Required
    public void setUrlCheckService(UrlCheckService urlCheckService) {
        this.urlCheckService = urlCheckService;
    }
}
