package ru.yandex.webmaster3.worker.url.checker3;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.storage.url.checker3.data.FetchUrlCheckDataBlockTaskData;
import ru.yandex.webmaster3.worker.Task;

/**
 * @author leonidrom
 */
@Component
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Slf4j
public class FetchUrlCheckDataBlockTask extends Task<FetchUrlCheckDataBlockTaskData> {
    private final UrlCheckDataBlockFetchersRegistry fetchersRegistry;

    @Override
    public Result run(FetchUrlCheckDataBlockTaskData data) throws Exception {
        var fetcher = fetchersRegistry.getFetcher(data.getBlockType());
        if (fetcher == null) {
            log.error("No fetcher for block type {}", data.getBlockType());
            return Result.FAIL;
        }

        boolean isOk = fetcher.fetchBlock(data.getRequestId(), data.getSearchBaseDate(), data.getParams());
        return isOk? Result.SUCCESS : Result.FAIL;
    }

    @Override
    public Class<FetchUrlCheckDataBlockTaskData> getDataClass() {
        return FetchUrlCheckDataBlockTaskData.class;
    }
}
