package ru.yandex.webmaster3.worker.url.checker3;

import lombok.RequiredArgsConstructor;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockType;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author leonidrom
 */
@Component
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class UrlCheckDataBlockFetchersRegistry {
    private final ApplicationContext applicationContext;
    private final Map<UrlCheckDataBlockType, AbstractUrlCheckDataBlockFetcher<?>> registry = new HashMap<>();

    @PostConstruct
    public void init() {
        var fetchersMap = applicationContext.getBeansOfType(AbstractUrlCheckDataBlockFetcher.class);
        fetchersMap.values().forEach(b -> registry.put(b.getBlockType(), b));
    }

    @Nullable
    public AbstractUrlCheckDataBlockFetcher<?> getFetcher(UrlCheckDataBlockType blockType) {
        return registry.getOrDefault(blockType, null);
    }
}
