package ru.yandex.webmaster3.worker.url.checker3.fetchers;

import NUrlChecker.Response;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckDeviceType;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckRequestParams;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockType;
import ru.yandex.webmaster3.storage.url.checker3.data.blocks.IndexingInfoData;
import ru.yandex.webmaster3.worker.url.checker3.AbstractUrlCheckDataBlockFetcher;

import static NUrlChecker.Response.TUrlCheckResponse.EStatusCode.ESC_NULL_CRAWL_INFO_RESULT;

/**
 * @author leonidrom
 *
 * Берет данные из ответа Роботного сервиса
 */
@Component
public class RobotIndexingInfoDataFetcher extends AbstractUrlCheckDataBlockFetcher<IndexingInfoData>  {
    @Override
    public IndexingInfoData doFetchBlock(DateTime searchBaseDate, UrlCheckRequestParams requestParams) throws Exception {
        return null;
    }

    @Override
    public IndexingInfoData doFetchBlock(Response.TUrlCheckResponse response) throws Exception {
        boolean noIndexingInfo = response.getStatusList().stream().anyMatch(code -> code == ESC_NULL_CRAWL_INFO_RESULT);
        if (noIndexingInfo) {
            return new IndexingInfoData();
        }

        Response.TUrlCheckResponse.TCrawlResult crawlResult = null;
        if (response.hasMobileCrawlResult()) {
            crawlResult = response.getMobileCrawlResult();
        } else if (response.hasDesktopCrawlResult()) {
            crawlResult = response.getDesktopCrawlResult();
        }

        if (crawlResult == null) {
            return null;
        }

        return new IndexingInfoData(new IndexingInfoData.IndexingInfo(
                crawlResult.getHttpCode(),
                crawlResult.getLastAccess(),
                crawlResult.getMimeType(),
                crawlResult.getRedirectTarget(),
                crawlResult.getRelCanonicalTarget()
        ));
    }

    @Override
    public Class<IndexingInfoData> getDataBlockClass() {
        return IndexingInfoData.class;
    }

    @Override
    public @NotNull UrlCheckDataBlockType getBlockType() {
        return UrlCheckDataBlockType.ROBOT_INDEXING_INFO;
    }
}
