package ru.yandex.webmaster3.worker.url.checker3.fetchers;

import NUrlChecker.Response;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.springframework.stereotype.Component;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckRequestParams;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockType;
import ru.yandex.webmaster3.storage.url.checker3.data.blocks.RotorCheckData;
import ru.yandex.webmaster3.worker.url.checker3.AbstractUrlCheckDataBlockFetcher;

import java.util.Base64;

/**
 * @author leonidrom
 *
 * Берет данные из ответа Роботного сервиса
 */
@Component
public class RotorCheckRenderOffDataFetcher extends AbstractUrlCheckDataBlockFetcher<RotorCheckData> {
    @Override
    public RotorCheckData doFetchBlock(DateTime searchBaseDate, UrlCheckRequestParams requestParams) throws Exception {
        return null;
    }

    @Override
    public RotorCheckData doFetchBlock(Response.TUrlCheckResponse response) throws Exception {
        String base64Screenshot = Base64.getEncoder().encodeToString(response.getRotorlessScreenshot().toByteArray());
        return new RotorCheckData(base64Screenshot);
    }

    @Override
    public Class<RotorCheckData> getDataBlockClass() {
        return RotorCheckData.class;
    }

    @Override
    public @NotNull UrlCheckDataBlockType getBlockType() {
        return UrlCheckDataBlockType.ROBOT_ROTOR_CHECK_RENDER_OFF;
    }
}
