package ru.yandex.webmaster3.worker.user;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.worker.client.WorkerClient;
import ru.yandex.webmaster3.core.worker.task.InitializeUserTaskData;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskState;
import ru.yandex.webmaster3.core.worker.task.PeriodicTaskType;
import ru.yandex.webmaster3.core.worker.task.TaskResult;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;
import ru.yandex.webmaster3.worker.PeriodicTask;
import ru.yandex.webmaster3.worker.TaskSchedule;

/**
 * @author avhaliullin
 */
@Slf4j
@Component("initializeAllUsersTask")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class InitializeAllUsersTask extends PeriodicTask<PeriodicTaskState> {

    private final UserHostsService userHostsService;
    @Qualifier("lbWorkerClient")
    private final WorkerClient workerClient;

    @Override
    public Result run(UUID runId) throws Exception {
        userHostsService.forEach(pair -> {
            workerClient.enqueueTask(new InitializeUserTaskData(pair.getLeft(), InitializeUserTaskData.EmailInitMode.NONE, null, null, null));
        });
        return new Result(TaskResult.SUCCESS);
    }

    @Override
    public PeriodicTaskType getType() {
        return PeriodicTaskType.INITIALIZE_ALL_USERS;
    }

    @Override
    public TaskSchedule getSchedule() {
        return TaskSchedule.never();
    }
}
