package ru.yandex.webmaster3.worker.user;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.addurl.AddUrlService;
import ru.yandex.webmaster3.core.antispam.threats.CheckForHostThreatsTaskData;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.IdUtils;
import ru.yandex.webmaster3.core.worker.client.WorkerClient;
import ru.yandex.webmaster3.core.worker.task.UserVerifiesHostTaskData;
import ru.yandex.webmaster3.storage.mobile.HostMobileAuditService;
import ru.yandex.webmaster3.worker.Task;

/**
 * ishalaru
 * 12.01.2021
 **/
@Slf4j
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Service
public class UserVerifiesHostTask extends Task<UserVerifiesHostTaskData> {
    private final WorkerClient workerClient;
    private final AddUrlService addUrlService;
    private final HostMobileAuditService hostMobileAuditService;

    @Override
    public Result run(UserVerifiesHostTaskData data) throws Exception {
        // нас интересуют только новые хосты, которых раньше не было
        if (data.getHostId() == null || !data.isNewHost()) {
            return Result.FAIL;
        }

        WebmasterHostId hostId = data.getHostId();
        log.info("Processing new verified host: {}", hostId);

        // проверим хост на угрозы
        workerClient.enqueueTask(new CheckForHostThreatsTaskData(hostId));

        // переобойдем его морду
        addUrlService.requestRecrawl(IdUtils.hostIdToReadableUrl(hostId) + "/");

        // и проверим на мобилопригодность
        hostMobileAuditService.recheck(hostId);

        return Result.SUCCESS;
    }

    @Override
    public Class<UserVerifiesHostTaskData> getDataClass() {
        return UserVerifiesHostTaskData.class;
    }
}
