package ru.yandex.webmaster3.worker.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import org.apache.commons.io.IOUtils;

import ru.yandex.webmaster3.core.WebmasterException;

/**
 * User: azakharov
 * Date: 21.04.15
 * Time: 13:42
 */
public class SortUtils {
    /**
     * sorts text file using external sort tool
     *
     * @param inputFileName
     * @param outputFileName
     */
    public static void sort(final File inputFileName, final File outputFileName) {
        final ArrayList<String> cmdList = new ArrayList<>();
        cmdList.add("sort");
        cmdList.add("-g");
        cmdList.add("--output=" + outputFileName.getAbsolutePath());
        cmdList.add(inputFileName.getAbsolutePath());
        String [] cmdArray = new String[cmdList.size()];
        cmdArray = cmdList.toArray(cmdArray);
        String[] envP = {"LC_COLLATE=C"};
        try {
            final Process p = Runtime.getRuntime().exec(cmdArray, envP);
            int val = p.waitFor();
            if (val != 0) {
                final String message = "sort exit code is nonzero: " + val + ", error:" + IOUtils.toString(p.getErrorStream());
                throw new WebmasterException(message, null);
            }
        } catch (IOException e) {
            throw new WebmasterException("sort throws IOException", null, e);
        } catch (InterruptedException e) {
            throw new WebmasterException("InterruptedException on waitFor", null, e);
        }
    }
}
