package ru.yandex.webmaster3.worker.util;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.events2.HostEvent;
import ru.yandex.webmaster3.core.events2.HostEventData;
import ru.yandex.webmaster3.core.events2.HostEventId;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;

/**
 * @author avhaliullin
 */
public class WorkerEventUtil {
    public static HostEvent createFromTask(WorkerTaskData taskData, WebmasterHostId hostId, HostEventData event) {
        return HostEvent.create(HostEventId.createFromTaskId(taskData.getTaskId()), hostId, event);
    }

    public static HostEvent createFromTaskUseHostId(WorkerTaskData taskData, HostEventData event) {
        return createFromTask(taskData, taskData.getHostId(), event);
    }
}
