package ru.yandex.webmaster3.worker.ytimport;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.storage.util.yt.YtPath;

/**
 * @author avhaliullin
 */
public class YtImportTaskInfo {
    private final YtPath ytTablePath;
    private final String clickhouseTableName;
    private final String clickhouseCreateSpec;
    private final String clickhouseInsertSpec;
    private final CompressionMode dataCompressionMode;
    private final boolean checkForTableEmptiness;

    @JsonCreator
    public YtImportTaskInfo(YtPath ytTablePath, String clickhouseTableName, String clickhouseCreateSpec, String clickhouseInsertSpec,
                            CompressionMode dataCompressionMode, boolean checkForTableEmptiness) {
        this.ytTablePath = ytTablePath;
        this.clickhouseTableName = clickhouseTableName;
        this.clickhouseCreateSpec = clickhouseCreateSpec;
        this.clickhouseInsertSpec = clickhouseInsertSpec;
        this.dataCompressionMode = dataCompressionMode;
        this.checkForTableEmptiness = checkForTableEmptiness;
    }

    public YtPath getYtTablePath() {
        return ytTablePath;
    }

    public String getClickhouseTableName() {
        return clickhouseTableName;
    }

    public String getClickhouseCreateSpec() {
        return clickhouseCreateSpec;
    }

    public String getClickhouseInsertSpec() {
        return clickhouseInsertSpec;
    }

    public CompressionMode getDataCompressionMode() {
        return dataCompressionMode;
    }

    public boolean isCheckForTableEmptiness() {
        return checkForTableEmptiness;
    }

    public enum CompressionMode {
        NONE,
        GZIP,
    }
}
