package ru.yandex.webmaster3.worker.ytimport;

import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseHost;
import ru.yandex.webmaster3.storage.ytimport.ImportPriority;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class YtImportTaskLocator {
    private final String clickhouseHostName;
    private final UUID importTaskId;
    private final ImportPriority priority;

    public YtImportTaskLocator(String clickhouseHostName, UUID importTaskId, ImportPriority priority) {
        this.clickhouseHostName = clickhouseHostName;
        this.importTaskId = importTaskId;
        this.priority = priority;
    }

    public String getClickhouseHostName() {
        return clickhouseHostName;
    }

    public UUID getImportTaskId() {
        return importTaskId;
    }

    public ImportPriority getPriority() {
        return priority;
    }

    @Override
    public String toString() {
        return "YtImportTaskLocator{" +
                "clickhouseHostName='" + clickhouseHostName + '\'' +
                ", importTaskId=" + importTaskId +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        YtImportTaskLocator locator = (YtImportTaskLocator) o;

        if (!clickhouseHostName.equals(locator.clickhouseHostName)) return false;
        return importTaskId.equals(locator.importTaskId);
    }

    @Override
    public int hashCode() {
        int result = clickhouseHostName.hashCode();
        result = 31 * result + importTaskId.hashCode();
        return result;
    }

    public static YtImportTaskLocator create(ClickhouseHost host, UUID taskId, ImportPriority priority) {
        return new YtImportTaskLocator(host.getHostURI().getHost(), taskId, priority);
    }
}
