#!/bin/sh
# должен быть включен инкрементальный бэкап

DATE=`date +%Y-%m-%d`
echo "regular snapshot $DATE"

SNAME="snapshot-regular-$DATE"

echo "Snapshot name: $SNAME"
echo "Clear all snapshots"
nodetool clearsnapshot

echo "Clear incremental backups"
for i in /var/lib/cassandra/data/*/*/backups/*; do rm -rf $i; done

echo "Taking schema"
_BACKUP_DIR="/var/lib/backup_cassandra"
_BACKUP_SCHEMA_DIR="$_BACKUP_DIR/$DATE/schema"
mkdir -p $_BACKUP_SCHEMA_DIR
cqlsh `hostname` -e "DESC SCHEMA" > "$_BACKUP_SCHEMA_DIR/keyspace_schema.cql"

echo "Taking snapshot"
nodetool snapshot -t $SNAME  #отключить flush memtables можно опцией -sf, но начиная с версии 3.4
