#!/bin/sh
#$1 - имя кейспэйса (бд)
#$2 - имя columnFamily (таблица)
#$3 - дата в формате YYYY-mm-dd HH:mm:ss.ms - точка, строго до которой нужно все восстановить. Например: 2017-08-06 18:25:31.546428443, 2017-08-06 18:25

# Перед запуском рекомендуется сделать create table, если таблица была удалена или схема испорчена

SNAPSHOT_BACKUP_NAME="snapshot-regular"

nodetool flush

echo "Cassandra stop"
/etc/init.d/cassandra stop

echo "Clear commitlogs"
rm -f /var/lib/cassandra/commitlog/*.*

echo "Clear sstables"
rm /var/lib/cassandra/data/$1/$2*/*.db

echo "Copy snapshots to the data directory"
SNAPSHOTS_BACKUP=`ls -1 -d /var/lib/cassandra/data/$1/$2*/snapshots/$SNAPSHOT_BACKUP_NAME*/*.db`
for f in $SNAPSHOTS_BACKUP
do
    TABLE=`echo $f | awk -F/ '{print $(NF-3)}'`

	echo "Copy $f to /var/lib/cassandra/data/$1/$TABLE"
    cp -p $f /var/lib/cassandra/data/$1/$TABLE/
done

echo "Copy the incremental backups to the data directory"
INCREMENTAL_BACKUP=`ls -1 -d /var/lib/cassandra/data/$1/$2*/backups/*.db`
for f in $INCREMENTAL_BACKUP
do
    TABLE=`echo $f | awk -F/ '{print $(NF-2)}'`

	file_date_str=$(stat -c %y $f)
    if [ "$3" ">" "$file_date_str" ]; then
        echo "Copy $f to /var/lib/cassandra/data/$1/$TABLE"
        cp -p $f /var/lib/cassandra/data/$1/$TABLE/
    fi
done

echo "Cassandra start"
/etc/init.d/cassandra start