#!/bin/bash -e

echo "##teamcity[message text='Create docker file']"
rm -f Dockerfile
_BUILD_DATE=$(date +"%FT%T%:z")
_BUILD_DATE_TAG=$(date +"%Y%m%d%H%M%S")

_DOCKER_IMAGE_NAME="registry.yandex.net/webmaster/backend-base"
_DOCKER_LATEST_TAG="${_DOCKER_IMAGE_NAME}:latest"
_DOCKER_DATE_TAG="${_DOCKER_IMAGE_NAME}:${_BUILD_DATE_TAG}"

cat Dockerfile.template | sed "s|{{ buildDate }}|${_BUILD_DATE}|g" > Dockerfile

echo "##teamcity[message text='Docker file content']"
cat Dockerfile

echo "##teamcity[progressStart 'Build image']"
docker build --pull -t ${_DOCKER_LATEST_TAG} -t ${_DOCKER_DATE_TAG} .
echo "##teamcity[progressFinish 'Build image']"

echo "##teamcity[progressStart 'Publish image']"
docker push ${_DOCKER_LATEST_TAG}
echo "##teamcity[progressFinish 'Publish image']"

echo "##teamcity[message text='Clean old images']"
_IMAGES_TO_REMOVE="$(docker images -q --filter=before=${_DOCKER_LATEST_TAG} --filter=label=webmaster-base-image.revision)"

if [[ -n "${_IMAGES_TO_REMOVE}" ]]; then
  echo "Remove old images: ${_IMAGES_TO_REMOVE}"
  docker rmi ${_IMAGES_TO_REMOVE}
fi
