#!/bin/bash

SECRETS=$(env | grep secret)

function getFileName {
	envSecret=`echo "${1#*_}"`
	envSecret=`echo ${envSecret//__/-}`
	envSecret=`echo $envSecret | tr _ .`
	echo $envSecret | tr - _
}

for sec in $SECRETS
do
  secKey=$(cut -d'=' -f1 <<<"$sec")
  fileName=$(getFileName $secKey)
  pass=$(eval "echo -n \"\$$secKey\"")
  if [ ! -z "$pass" ]
  then
      echo -n "$pass" > /etc/yandex/webmaster3/secrets/$fileName
  fi
done
