#!/usr/bin/env python

__author__ = 'aherman'

import sys
import os.path

_srcPath = os.path.abspath(os.path.dirname(__file__) + "/../src/main/python")
_libPath = os.path.abspath(os.path.dirname(__file__) + "/../lib")

sys.path.append(_srcPath)

(major, minor) = sys.version_info[:2]
if major != 2:
    (major, minor) = (None, None)
else:
    if minor not in [6, 7]:
        (major, minor) = (None, None)

if not major:
    import packagingtools.packagingException as pe
    raise pe.PackagingException("Unsupported version of python, 2.6 or 2.7 are supported")

_jinjaVersion = "2.6"
_jinjaPath = _libPath + "/Jinja2-%s-py%d.%d.egg" % (_jinjaVersion, major, minor)

sys.path.append(_jinjaPath)

import packagingtools.deploy
from optparse import OptionParser
import time
start_time = time.time()

parser = OptionParser("usage: %prog [options] moduleName")
parser.add_option("--clean",
                  action="store_true", dest="mvnClean", default=False,
                  help="use mvn clean before build")
parser.add_option("--runtests",
                  action="store_true", dest="runtests", default=False,
                  help="run tests after build")
parser.add_option("--offline",
                  action="store_true", dest="offline", default=False,
                  help="run maven in offline mode")
parser.add_option("--skipIncrementalBuild",
                  action="store_true", dest="skipIncrementalBuild", default=False,
                  help="skip incremental build")
parser.add_option("--yamake",
                  action="store_true", dest="useYaMake", default=False,
                  help="use ya.make instead of mvn install")

(options, args) = parser.parse_args()
if len(args) != 1:
    parser.error("Usage: moduleName")

packagingtools.deploy.deployPackage(args[0],
                                    mvnClean=options.mvnClean,
                                    skipTests=not options.runtests,
                                    offline=options.offline,
                                    skipIncrementalBuild=options.skipIncrementalBuild,
                                    useYaMake=options.useYaMake
                                    )
print("--- deploy takes %s seconds ---" % (time.time() - start_time))
