#!/usr/bin/env python

__author__ = 'aherman'

import sys
import os.path

_srcPath = os.path.abspath(os.path.dirname(__file__) + "/../src/main/python")
_libPath = os.path.abspath(os.path.dirname(__file__) + "/../lib")

sys.path.append(_srcPath)

(major, minor) = sys.version_info[:2]
if major != 2:
    (major, minor) = (None, None)
else:
    if minor not in [6, 7]:
        (major, minor) = (None, None)

if not major:
    import packagingtools.packagingException as pe
    raise pe.PackagingException("Unsupported version of python, 2.6 or 2.7 are supported")

_jinjaVersion = "2.6"
_jinjaPath = _libPath + "/Jinja2-%s-py%d.%d.egg" % (_jinjaVersion, major, minor)

sys.path.append(_jinjaPath)

import packagingtools.makepackage

if len(sys.argv) < 2:
    print "Usage: moduleName"
else:
    useYaMake = False
    mvnClean = True
    if len(sys.argv) >=3:
        if sys.argv[2] == "-noclean":
            mvnClean = False
        if sys.argv[2] == "-yamake":
            useYaMake = True

    packagingtools.makepackage.makePackage(sys.argv[1], useYaMake)
