#!/usr/bin/env python

import sys
import os.path

_srcPath = os.path.abspath(os.path.dirname(__file__) + "/../src/main/python")
_libPath = os.path.abspath(os.path.dirname(__file__) + "/../lib")

sys.path.append(_srcPath)

(major, minor) = sys.version_info[:2]
if major != 2:
    (major, minor) = (None, None)
else:
    if minor not in [6, 7]:
        (major, minor) = (None, None)

if not major:
    import packagingtools.packagingException as pe
    raise pe.PackagingException("Unsupported version of python, 2.6 or 2.7 are supported")

_jinjaVersion = "2.6"
_jinjaPath = _libPath + "/Jinja2-%s-py%d.%d.egg" % (_jinjaVersion, major, minor)

sys.path.append(_jinjaPath)

import packagingtools.makepackage

if len(sys.argv) < 3:
    print "Usage: moduleName outputDir"
else:
    packagingtools.makepackage.makeStartScriptYaDeploy(sys.argv[1], sys.argv[2])
