__author__ = 'aherman'

import json


def generate(path, applicationConfig):
    acJson = {
        "project": applicationConfig.project,
        "module": applicationConfig.module,
        "version": applicationConfig.version,
        "vcs": {
            "revision": applicationConfig.repositoryRevision,
            "url": applicationConfig.repositoryUrl
        },
        "build-date": applicationConfig.buildDate,

        "folders": {
            "config": {
                "path": applicationConfig.folderHelper.etcFolder
            },
            "data": {
                "path": applicationConfig.folderHelper.dataFolder
            },
            "temp": {
                "path": applicationConfig.folderHelper.tempFolder
            },
        },

        "log-files": applicationConfig.logFiles
    }

    if applicationConfig.httpConfig is not None:
        acJson["http"] = {
            "port": applicationConfig.httpConfig.port
        }

    with open(path, "w") as f:
        json.dump(acJson, f, indent=2)
