#!/usr/bin/env python

import os
import stat
import subprocess

import applicationConfig as ac
import applicationJsonGenerator
import fileGenerator
import pathContainers as pc
import utils


def makeQloudImage(modulePath):
    applicationConfig = utils.createApplicationConfig(modulePath)
    applicationConfig.packagingMode = "qloud"
    applicationConfig.deployMode = "qloud"

    applicationQloudJson = applicationConfig.assemblyHelper.path + "/application.qloud.json"
    if os.path.exists(applicationQloudJson):
        print "Load: {0}".format(applicationQloudJson)
        with open(applicationQloudJson) as applicationQloudJsonFile:
            applicationQloudConfig = ac.ApplicationConfig()
            ac.parseApplicationConfigJson(applicationQloudJsonFile, applicationQloudConfig)
            applicationQloudJsonFile.close()
            applicationConfig = ac.mergeConfigs(applicationConfig, applicationQloudConfig)

    applicationConfig.folderHelper = pc.QloudFolderHelper(applicationConfig)
    ac.resolveProperties(applicationConfig)
    ac.setDefaults(applicationConfig)

    currentWorkingDirectoryCache = os.getcwd()
    os.chdir(applicationConfig.assemblyHelper.path)

    utils.runMaven(applicationConfig, skipTests=False)

    fileGenerator.generateStartScript(applicationConfig)
    fileGenerator.generateQloudScripts(applicationConfig)
    fixPermissions(applicationConfig)
    applicationJsonGenerator.generate(applicationConfig.assemblyHelper.binFolder + "/application.json", applicationConfig)
    runDockerBuild(applicationConfig)

    os.chdir(currentWorkingDirectoryCache)

def generateQloudScripts(modulePath):
    applicationConfig = utils.createApplicationConfig(modulePath)
    applicationConfig.packagingMode = "qloud"
    applicationConfig.deployMode = "qloud"

    applicationQloudJson = applicationConfig.assemblyHelper.path + "/application.qloud.json"
    if os.path.exists(applicationQloudJson):
        print "Load: {0}".format(applicationQloudJson)
        with open(applicationQloudJson) as applicationQloudJsonFile:
            applicationQloudConfig = ac.ApplicationConfig()
            ac.parseApplicationConfigJson(applicationQloudJsonFile, applicationQloudConfig)
            applicationQloudJsonFile.close()
            applicationConfig = ac.mergeConfigs(applicationConfig, applicationQloudConfig)

    applicationConfig.folderHelper = pc.QloudFolderHelper(applicationConfig)
    ac.resolveProperties(applicationConfig)
    ac.setDefaults(applicationConfig)

    currentWorkingDirectoryCache = os.getcwd()
    os.chdir(applicationConfig.assemblyHelper.path)
    fileGenerator.generateQloudScripts(applicationConfig)
    os.chdir(currentWorkingDirectoryCache)


def fixPermissions(applicationConfig):
    for root, dirs, files in os.walk(applicationConfig.assemblyHelper.binFolder):
        for file in files:
            os.chmod(os.path.join(root, file), stat.S_IRWXU | stat.S_IRGRP | stat.S_IROTH)

def runDockerBuild(applicationConfig):
    assemblyRoot = applicationConfig.assemblyHelper.assemblyRoot
    imageId = subprocess.check_output(["docker", "build", "--pull", "-q", assemblyRoot])
    print "Built docker image {0}".format(imageId)
    dockerImageIdFile = "{0}/docker-image-id.txt".format(assemblyRoot)
    with open(dockerImageIdFile, "w") as imageIdFile:
        imageIdFile.write(imageId)
