#!/usr/bin/env python

import getpass
import os
import subprocess
import shutil
import stat
from packagingtools.packagingException import PackagingException

import utils
import fileGenerator
import pathContainers as pc
import applicationConfig as ac
import applicationJsonGenerator

# - -run maven packaging-
# - -advance package version-
# - -parse project, module, version and revision-
# - -commit changelog-
# - -generate start.sh script-
# - -create debian template folder-
# - generate logrotate, monrun (if not exists)
# - generate init.d
# - -copy files to debian template-
# - -run debuild-

# Predefined properties
# PROJECT    - realty
# MODULE     - sharder
# VERSION    - 1.6.171
# REVISION   - 3ahbcd123
# BUILD_DATE - 2012-07-25T12:34:02


def makePackage(modulePath, useYaMake = False):
    applicationConfig = utils.createApplicationConfig(modulePath)
    applicationConfig.packagingMode = "debian"
    applicationConfig.folderHelper = pc.DebianFolderHelper(applicationConfig)
    ac.resolveProperties(applicationConfig)
    ac.setDefaults(applicationConfig)

    currentWorkingDirectoryCache = os.getcwd()
    os.chdir(applicationConfig.assemblyHelper.path)

    if useYaMake:
        utils.runMaven(applicationConfig, skipTests=False)
    else:
        utils.runYaMake(applicationConfig)
    cleanDebianFolder(applicationConfig)
    createDebianTemplateFolder(applicationConfig)
    fileGenerator.generateStartScript(applicationConfig)
    fileGenerator.generateDebianScripts(applicationConfig)
    utils.copyDeployment(applicationConfig)
    # generateMonrun(applicationConfig)
    applicationJsonGenerator.generate(applicationConfig.assemblyHelper.binFolder + "/application.json", applicationConfig)
    installFiles(applicationConfig)

    # deb package is build by Teamcity
    runDebuild(applicationConfig)

    os.chdir(currentWorkingDirectoryCache)

def makeStartScript(modulePath, binDir):
    print 'modulePath = ' + modulePath
    print 'binDir = ' + binDir
    applicationConfig = utils.createApplicationConfig(modulePath)
    applicationConfig.packagingMode = "debian"
    applicationConfig.folderHelper = pc.DebianFolderHelper(applicationConfig)
    applicationConfig.assemblyHelper.binFolder = binDir
    ac.resolveProperties(applicationConfig)
    ac.setDefaults(applicationConfig)

    currentWorkingDirectoryCache = os.getcwd()
    os.chdir(applicationConfig.assemblyHelper.path)

    fileGenerator.generateStartScript(applicationConfig)
    # generateMonrun(applicationConfig)
    applicationJsonGenerator.generate(applicationConfig.assemblyHelper.binFolder + "/application.json", applicationConfig)
    # installFiles(applicationConfig)
    os.chdir(currentWorkingDirectoryCache)

def makeStartScriptYaDeploy(modulePath, buildRoot):
    print 'modulePath = ' + modulePath
    print 'buildRoot = ' + buildRoot
    applicationConfig = utils.createApplicationConfig(modulePath)
    applicationConfig.packagingMode = "debian"
    applicationConfig.folderHelper = pc.YaDeployFolderHelper(applicationConfig)
    applicationConfig.assemblyHelper.binFolder = buildRoot + "/bin"
    applicationConfig.assemblyHelper.etcFolder = buildRoot + "/etc"
    ac.resolveProperties(applicationConfig)
    ac.setDefaults(applicationConfig)

    currentWorkingDirectoryCache = os.getcwd()
    os.chdir(applicationConfig.assemblyHelper.path)

    fileGenerator.generateDeployScripts(applicationConfig)
    # generateMonrun(applicationConfig)
    applicationJsonGenerator.generate(applicationConfig.assemblyHelper.binFolder + "/application.json", applicationConfig)
    # installFiles(applicationConfig)
    os.chdir(currentWorkingDirectoryCache)


# def advancePackageVersion(applicationConfig):
#     subprocess.check_call(
#         ["dch", "--increment", "--distributor=debian", "--no-auto-nmu", "--changelog",
#          applicationConfig.assemblyHelper.changelogPath]
#     )


# def commitChangelog(assemblyFolder, projectInfo):
#     subprocess.check_call(
#         ["hg", "commit", "--message", "New version {0}".format(projectInfo.version),
#          assemblyFolder.getChangelogPath()]
#     )


# def generateMonrun(applicationConfig):
#     pt.copyFileAndResolveProperties(assemblyFolder.getMonrunFile(),
#         assemblyFolder.getMonrunTargetFile(projectInfo.packageName),
#         projectInfo, debianFolder)


def cleanDebianFolder(applicationConfig):
    packagePath = applicationConfig.assemblyHelper.getPackagePath(applicationConfig.packageName)
    if not os.path.exists(packagePath):
        os.mkdir(packagePath)
    else:
        subprocess.check_call(
            ["dh_clean",
                "debian/{0}.logrotate".format(applicationConfig.packageName),
                "debian/{0}.init.d".format(applicationConfig.packageName),
                "debian/{0}.postinst".format(applicationConfig.packageName),
                "debian/{0}.postrm".format(applicationConfig.packageName),
                "debian/{0}.monrun".format(applicationConfig.packageName)
            ]
        )


def createDebianTemplateFolder(applicationConfig):
    assemblyHelper = applicationConfig.assemblyHelper
    debianHelper = applicationConfig.folderHelper
    os.makedirs(assemblyHelper.getLocationInPackage(applicationConfig.packageName, debianHelper.binFolder))
    os.makedirs(assemblyHelper.getLocationInPackage(applicationConfig.packageName, debianHelper.etcFolder))
    os.makedirs(assemblyHelper.getLocationInPackage(applicationConfig.packageName, debianHelper.libFolder))
    os.makedirs(assemblyHelper.getLocationInPackage(applicationConfig.packageName, debianHelper.tempFolder))
    os.makedirs(assemblyHelper.getLocationInPackage(applicationConfig.packageName, debianHelper.dataFolder))


def installFilesFromFolder(folder, target, mode):
    if not os.path.exists(target):
        os.makedirs(target)

    if not os.path.isdir(target):
        raise PackagingException("{0} must be a folder".format(target))

    files = os.listdir(folder)
    for f in files:
        srcFile = "{0}/{1}".format(folder, f)
        targetFile = "{0}/{1}".format(target, f)
        if os.path.isdir(srcFile):
            shutil.copytree(srcFile, targetFile)
            os.chmod(targetFile, mode | stat.S_IXUSR | stat.S_IXGRP | stat.S_IXOTH)
        else:
            shutil.copy(srcFile, targetFile)
            os.chmod(targetFile, mode)
        # subprocess.check_call(["install", "--mode={0}".format(mode), f, target])


def installBinFiles(applicationConfig):
    folder = applicationConfig.assemblyHelper.binFolder
    target = applicationConfig.assemblyHelper.getLocationInPackage(applicationConfig.packageName,
                                                                   applicationConfig.folderHelper.binFolder)
    # installFilesFromFolder(folder, target, "755")
    installFilesFromFolder(folder, target, stat.S_IRWXU | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)


def installEtcFiles(applicationConfig):
    folder = applicationConfig.assemblyHelper.etcFolder
    target = applicationConfig.assemblyHelper.getLocationInPackage(applicationConfig.packageName,
                                                                   applicationConfig.folderHelper.etcFolder)
    # installFilesFromFolder(folder, target, "644")
    installFilesFromFolder(folder, target, stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IROTH)


def installLibFiles(applicationConfig):
    folder = applicationConfig.assemblyHelper.libFolder
    target = applicationConfig.assemblyHelper.getLocationInPackage(applicationConfig.packageName,
                                                                   applicationConfig.folderHelper.libFolder)
    # installFilesFromFolder(folder, target, "644")
    installFilesFromFolder(folder, target, stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IROTH)


def installMonrunFiles(applicationConfig):
    monrunFilePath = applicationConfig.assemblyHelper.getMonrunTargetFile(applicationConfig.packageName)
    if os.path.exists(monrunFilePath):
        monrunInstallPath = applicationConfig.assemblyHelper.getLocationInPackage(applicationConfig.packageName,
            applicationConfig.folderHelper.monrunFilePath)
        monrunFolder = applicationConfig.assemblyHelper.getLocationInPackage(applicationConfig.packageName,
            applicationConfig.folderHelper.monrunFolderPath)
        # subprocess.check_call(["install", "-d", monrunFolder])
        os.mkdir(monrunFolder)
        # subprocess.check_call(["install", "--mode=644", monrunFilePath, monrunInstallPath])
        shutil.copyfile(monrunFilePath, monrunInstallPath)
        os.chmod(monrunInstallPath, stat.S_IRUSR | stat.S_IWUSR | stat.S_IRGRP | stat.S_IROTH)
    pass


def installFiles(applicationConfig):
    print "Install assembly files"
    installBinFiles(applicationConfig)
    installEtcFiles(applicationConfig)
    installLibFiles(applicationConfig)
    installMonrunFiles(applicationConfig)


def runDebuild(applicationConfig):
    print "Building deb package as " + str(getpass.getuser())
    os.environ['PROJECT_MODULE'] = "{0}-{1}".format(applicationConfig.project, applicationConfig.module)
    subprocess.check_call(["dpkg-buildpackage", "-rfakeroot", "-sa", "-e{0}".format(os.environ['EMAIL']), "-b"])
