import os.path


class AssemblyHelper(object):
    def __init__(self, path):
        path = os.path.abspath(path)
        self.path = path

        self.assemblyRoot = "{0}/target/assembly".format(path)
        self.binFolder = "{0}/target/assembly/bin".format(path)
        self.etcFolder = "{0}/target/assembly/etc".format(path)
        self.libFolder = "{0}/target/assembly/lib".format(path)
        self.monrunPath = "{0}/target/assembly/monrun.conf".format(path)
        self.changelogPath = "{0}/debian/changelog".format(path)
        self.pomPath = "{0}/pom.xml".format(path)
        self.debianFolder = "{0}/debian".format(path)

    def getPackagePath(self, packageName):
        return "{0}/debian/{1}".format(self.path, packageName)

    def getLocationInPackage(self, packageName, location):
        return "{0}/debian/{1}{2}".format(self.path, packageName, location)

    def getLogrotateFile(self, packageName):
        return "{0}/debian/{1}.logrotate".format(self.path, packageName)

    def getInitFile(self, packageName):
        return "{0}/debian/{1}.init.d".format(self.path, packageName)

    def getPostinsFile(self, packageName):
        return "{0}/debian/{1}.postinst".format(self.path, packageName)

    def getPostrmFile(self, packageName):
        return "{0}/debian/{1}.postrm".format(self.path, packageName)

    def getMonrunTargetFile(self, packageName):
        return "{0}/debian/{1}.monrun".format(self.path, packageName)

    def getUbicFile(self, packageName, applicationName):
        return "{0}/debian/{1}/etc/ubic/service/{2}.json".format(self.path, packageName, applicationName)


class FolderHelper(object):
    def __init__(self):
        self.binFolder = ""
        self.libFolder = ""
        self.dataFolder = ""
        self.tempFolder = ""
        self.etcFolder = ""

        self.logFolder = ""
        self.logFile = ""
        self.gcLogFile = ""
        self.shLogFile = ""

        self.pidPath = ""
        self.pidFolder = ""
        self.hprofFolder = ""


class DebianFolderHelper(FolderHelper):
    def __init__(self, applicationConfig):
        super(DebianFolderHelper, self).__init__()
        self.binFolder = "/usr/lib/yandex/{0}/{1}/bin".format(applicationConfig.project, applicationConfig.module)
        self.libFolder = "/usr/lib/yandex/{0}/{1}/lib".format(applicationConfig.project, applicationConfig.module)
        self.dataFolder = "/var/lib/yandex/{0}/{1}".format(applicationConfig.project, applicationConfig.module)
        self.tempFolder = "/tmp/yandex/{0}/{1}".format(applicationConfig.project, applicationConfig.module)
        self.etcFolder = "/etc/yandex/{0}/{1}".format(applicationConfig.project, applicationConfig.module)

        self.logFolder = "/var/log/{0}".format(applicationConfig.project)
        self.logFile = "{0}-{1}.log".format(applicationConfig.project, applicationConfig.module)
        self.gcLogFile = "{0}-{1}-gc.log".format(applicationConfig.project, applicationConfig.module)
        self.shLogFile = "{0}-{1}-sh.log".format(applicationConfig.project, applicationConfig.module)

        self.pidPath = "/var/run/{0}/{1}.pid".format(applicationConfig.project, applicationConfig.module)
        self.pidFolder = "/var/run/{0}".format(applicationConfig.project)

        self.hprofFolder = "/var/log/{0}/hprof/{0}-{1}/".format(applicationConfig.project, applicationConfig.module)

        self.monrunFolder = "/etc/monrun/conf.d/"
        self.monrunPath = "/etc/monrun/conf.d/{0}-{1}.conf".format(applicationConfig.project, applicationConfig.module)


class DevelopmentFolderHelper(FolderHelper):
    def __init__(self, applicationConfig):
        super(DevelopmentFolderHelper, self).__init__()
        self.binFolder = "./bin"
        self.libFolder = "./lib"
        self.dataFolder = "./data"
        self.tempFolder = "./tmp"
        self.etcFolder = "./etc"

        self.logFolder = "./log"
        self.logFile = "{0}-{1}.log".format(applicationConfig.project, applicationConfig.module)
        self.gcLogFile = "{0}-{1}-gc.log".format(applicationConfig.project, applicationConfig.module)
        self.shLogFile = "{0}-{1}-sh.log".format(applicationConfig.project, applicationConfig.module)

        self.pidPath = "./{0}-{1}.pid".format(applicationConfig.project, applicationConfig.module)
        self.pidFolder = "./"
        self.hprofFolder = "./log/hprof"

class QloudFolderHelper(FolderHelper):
    def __init__(self, applicationConfig):
        super(QloudFolderHelper, self).__init__()
        self.binFolder = "/{0}-{1}/bin".format(applicationConfig.project, applicationConfig.module)
        self.libFolder = "/{0}-{1}/lib".format(applicationConfig.project, applicationConfig.module)
        self.dataFolder = "/{0}-{1}/data".format(applicationConfig.project, applicationConfig.module)
        self.tempFolder = "/{0}-{1}/tmp".format(applicationConfig.project, applicationConfig.module)
        self.etcFolder = "/{0}-{1}/etc".format(applicationConfig.project, applicationConfig.module)

        self.logFolder = "/{0}-{1}/log".format(applicationConfig.project, applicationConfig.module)
        self.logFile = "{0}-{1}.log".format(applicationConfig.project, applicationConfig.module)
        self.gcLogFile = "{0}-{1}-gc.log".format(applicationConfig.project, applicationConfig.module)
        self.shLogFile = "{0}-{1}-sh.log".format(applicationConfig.project, applicationConfig.module)

        self.pidPath = ""
        self.pidFolder = ""

        self.hprofFolder = "/{0}-{1}/log/hprof"

        self.monrunFolder = "/etc/monrun/conf.d/"
        self.monrunPath = "/etc/monrun/conf.d/{0}-{1}.conf".format(applicationConfig.project, applicationConfig.module)

class YaDeployFolderHelper(FolderHelper):
    def __init__(self, applicationConfig):
        super(YaDeployFolderHelper, self).__init__()
        self.binFolder = "/{0}-{1}/bin".format(applicationConfig.project, applicationConfig.module)
        self.libFolder = "/{0}-{1}/lib".format(applicationConfig.project, applicationConfig.module)
        self.dataFolder = "/{0}-{1}/data".format(applicationConfig.project, applicationConfig.module)
        self.tempFolder = "/{0}-{1}/tmp".format(applicationConfig.project, applicationConfig.module)
        self.etcFolder = "/{0}-{1}/etc".format(applicationConfig.project, applicationConfig.module)

        self.logFolder = "/{0}-{1}/log".format(applicationConfig.project, applicationConfig.module)
        self.logFile = "{0}-{1}.log".format(applicationConfig.project, applicationConfig.module)
        self.gcLogFile = "{0}-{1}-gc.log".format(applicationConfig.project, applicationConfig.module)
        self.shLogFile = "{0}-{1}-sh.log".format(applicationConfig.project, applicationConfig.module)

        self.pidPath = "/{0}-{1}/pid.pid".format(applicationConfig.project, applicationConfig.module)
        self.pidFolder = "/{0}-{1}".format(applicationConfig.project, applicationConfig.module)

        self.hprofFolder = "/{0}-{1}/log/hprof".format(applicationConfig.project, applicationConfig.module)

        self.monrunFolder = "/etc/monrun/conf.d/"
        self.monrunPath = "/etc/monrun/conf.d/{0}-{1}.conf".format(applicationConfig.project, applicationConfig.module)
