__author__ = 'aherman'

import os
import subprocess


def updateRepositoryInfo(applicationConfig):
    if os.path.isdir(".svn"):
        return _getSvnRevision(applicationConfig)
    elif os.path.isdir(".hg"):
        return _getMercurialRevision(applicationConfig)

    print "Unable to get repository revision"
    return None


def _getMercurialRevision(applicationConfig):
    versionLine = subprocess.Popen(["hg", "parent"], stdout=subprocess.PIPE).communicate()[0].splitlines()[0]
    applicationConfig.repositoryRevision = versionLine.split(':')[2]

    paths = subprocess.Popen(["hg", "paths"], stdout=subprocess.PIPE).communicate()[0].splitlines()
    for path in paths:
        if path.startswith("default ="):
            applicationConfig.repositoryUrl = path.split(" = ")[1]
            break


def _getSvnRevision(applicationConfig):
    lines = subprocess.Popen(["svn", "info"], stdout=subprocess.PIPE).communicate()[0].splitlines()
    versionLine = None
    url = None
    for line in lines:
        if line.startswith("Last Changed Rev:"):
            versionLine = line
        elif line.startswith("URL:"):
            url = line.split(": ")[1]

    if versionLine is not None:
        applicationConfig.repositoryRevision = versionLine.split(": ")[1]
        applicationConfig.repositoryUrl = url
