#!/bin/bash
#
# Report disks usage
#
# $Id: diskusage.sh,v 1.5 2008-06-10 17:52:19 andozer Exp $
#
me=${0##*/}	# strip path
me=${me%.*}	# strip extension
BASE=$HOME/agents
CONF=$BASE/etc/$me.conf
UNITS=%
PATH=/bin:/sbin:/usr/bin:/usr/sbin

[ -s $CONF ] && . $CONF

UPTIME=0
D0=${DISK0:-/}
D1=${DISK1:-/local}
DESC="${DESC:-$D0 $D1}"

#[ -d $TMP ] || mkdir -p $TMP

report_diskfree () {
        while read rdev total used avail cap mountpt
        do
                if [ "$mountpt" = "$D0" -o "$rdev" = "$D0" ]
		then
			case "$UNITS" in
				%) C0=${cap%\%}	;;
				*) C0="$used"	;;
			esac
                elif [ "$mountpt" = "$D1" -o "$rdev" = "$D1" ]
		then
			case "$UNITS" in
				%) C1=${cap%\%}	;;
				*) C1="$used"	;;
			esac
		fi
        done
        echo "${C0:--1}"
	echo "${C1:--1}"
	echo "$UPTIME"
	echo "$DESC"
}

case "$UNITS" in
	[Kk])	u=k ;;
	[Mm])	u=m ;;
	[Gg])	u=g ;;
	*)	u="" ;;
esac

if [ `uname` = 'FreeBSD' -a `uname -r | grep ^[123]` ]
then
	df -k -t ufs | report_diskfree
else
	df -l$u 2>/dev/null | report_diskfree
fi
