#!/bin/bash
#
# Report system load average
#
# $Id: la.sh,v 1.4 2008-06-10 17:53:26 andozer Exp $
#
#me=${0##*/}	# strip path
#me=${me%.*}	# strip extension
#BASE=$HOME/agents
#CONF=$BASE/etc/$me.conf
#TMP=$BASE/tmp
#PREV=$TMP/$me.prev
#PATH=/bin:/sbin:/usr/bin:/usr/sbin
OID=loadavg
FMT='%d\n%d\n0\nla1/la15\n'

#[ -s $CONF ] && . $CONF

case `uname` in
FreeBSD)
	sysctl -n vm.$OID | awk -v fmt="$FMT" '{ printf fmt, $2 * 100, $4 * 100; }'
	;;
Linux)
	awk -vfmt="$FMT" '{ printf fmt, $1 * 100, $3 * 100; }' < /proc/$OID
	;;
*)
	uptime | cut -f 2 -d : | tr -d ',' | \
		awk -vfmt="$FMT" '{ printf fmt, $1 * 100, $3 * 100; }'
	;;
esac
