#!/bin/sh
#
# Report open files in system as well as diff between the current
# state and last one
#
# $Id: openfiles.sh,v 1.4 2005-06-14 19:10:58 gvs Exp $
#
me=${0##*/}	# strip path
me=${me%.*}	# strip extension
BASE=$HOME/agents
CONF=$BASE/etc/$me.conf
TMP=$BASE/tmp
PREV=$TMP/$me.prev
PATH=/bin:/sbin:/usr/bin:/usr/sbin

[ -s $CONF ] && . $CONF

case `uname` in
FreeBSD)	if [ `uname -r | cut -f 1 -d .` -gt 3 ]
		then
			VAL1=`sysctl -n kern.openfiles`
		else
			VAL1=`pstat -f | head -1 | cut -f 1 -d /`
		fi
		;;

Linux)		set -- `cat /proc/sys/fs/file-nr`
		case `uname -r` in
			2.6*) VAL1="$1" ;;
			2.4*) VAL1="$2" ;;
			*)
				if [ "$2" -eq 0 ]
				then
					VAL1="$1"
				else
					VAL1="$2"
				fi
			;;
		esac
		;;
*)		VAL1=`pstat -f | head -1 | cut -f 1 -d /` ;;
esac

if [ -s $PREV ]
then
        VAL2=`cat $PREV`
        VAL2=`expr ${VAL1:-0} - ${VAL2:-0}`
        [ $VAL2 -lt 0 ] && VAL2=`expr 0 - $VAL2`
else
        VAL2=0
fi

UPTIME=0
DESC="${DESC:-Open files}"

[ -d $TMP ] || mkdir -p $TMP

echo "$VAL1" > $PREV
echo "$VAL1
$VAL2
$UPTIME
$DESC"
