#!/bin/sh
#
# Report memory usage (total/used)
#
# $Id: pages.sh,v 1.5 2004-08-03 10:28:46 gvs Exp $
#
#me=${0##*/}	# strip path
#me=${me%.*}	# strip extension
#BASE=$HOME/agents
#CONF=$BASE/etc/$me.conf
#TMP=$BASE/tmp
#PREV=$TMP/$me.prev
#PATH=/bin:/sbin:/usr/bin:/usr/sbin
#[ -s $CONF ] && . $CONF

case `uname` in
FreeBSD)
	printf "%d\n%d\n0\ntotal/active pages\n" \
		`sysctl -n vm.stats.vm.v_wire_count` \
		`sysctl -n vm.stats.vm.v_active_count`
	;;
Linux)
	case `uname -r` in
	2.[1-5].*)
	    awk '($1 == "Mem:") {
		printf "%d\n%d\n0\nFree/total RAM\n",
				($4 + $6 + $7) / 1024, $2 / 1024;
	    }' < /proc/meminfo
	    ;;
	*)
	    awk '$1 == "MemTotal:" { total = $2 }
		($1 == "MemFree:" || $1 == "Buffers:" || $1 == "Cached:") {
			free += $2
		}
		END { printf "%d\n%d\n0\nFree/total RAM\n", free, total}
		' < /proc/meminfo
	    ;;
	esac
	;;
*)
	vmstat | tail -1 | awk '{ print $3 "\n" $2 "\n0\nFree/active pages"; }'
	;;
esac
