#!/bin/sh
#
# $Id: procs.sh,v 1.1 2005-01-19 14:33:14 gvs Exp $
#
# Get processes for MRTG. In - process on command line, Out - total processes
#

# Environment
me=${0##*/}     # strip path
me=${me%.*}     # strip extension
BASE=$HOME/agents
ETC=$BASE/etc
CONF=$ETC/$me.conf
WATCH=httpd

[ -s $CONF ] && . $CONF

ps ax | awk "
( \$1 == \"PID\" ) { next; }
{
	total++;
	if (\$5 ~ /$WATCH/) choosen++;
} END {
	printf \"%d\\n%d\\n0\\n%s\\n\", choosen, total, \"${DESCR:-$WATCH}\";
}"
