BEGIN {
    startTime = systime() - 60 * 60 * 3 - 60 * 5;
    if (showLog < 0) {
	showLog = 0;
    }
    if (showNumLines < 0) {
	showNumLines = 2;
    }
    startErrorLine =( -2*showNumLines);

    errors = 0;
}

/ ERROR / { 
    
    sub(/^\[/, "");
    sub(/,[0-9]*\]/, "");
    sub(/^\[/, "");
    sub(/[-]/, " ");
    sub(/[-]/, " ");
    sub(/[:]/, " ");
    sub(/[:]/, " ");
    
    ts = mktime($1" "$2" "$3" "$4" "$5" "$6); 
    if (ts > startTime) {
	errors++;
	startErrorLine = FNR;
    }
}

{
    if (showLog == 1 && FNR >= startErrorLine - showNumLines && FNR < startErrorLine + showNumLines) {
	print;
    }
}

END { 
    print "errors: " errors;
}
