#!/bin/bash

_PERIOD_SECONDS=300

send_wm_errors () {
metric="webmaster-viewer-xscript-errors"
amount=$(timetail -n $_PERIOD_SECONDS /var/log/xscript/default.log | grep -c "err: wm-error:")
gmetric -n $metric -v $amount -x $_PERIOD_SECONDS -t float
}

send_wm_timeouts () {
amount=$(timetail -n $_PERIOD_SECONDS /var/log/xscript/default.log | grep "err: wm-error:" | grep -c "block is timed out")
metric="webmaster-viewer-xscript-timeouts"
gmetric -n $metric -v $amount -x $_PERIOD_SECONDS -t float
}

test -e /usr/bin/gmetric || exit 0
$1
