#!/bin/bash

log() {
  echo `date +"[%d/%b/%Y:%H:%M:%S]"`" $1"
}

log "Start rsync task: `date +'%F %T'`"

_TMP_EXTENSION=".tmp"
_TMP_FAILED_EXTENSION=".tmp.failed"

failed_rsyncs=0
ok_rsyncs=0

prepare_file() {
  local fullFilePath="$1"
  local tmpFilePath="$2"
  local tmpFailedPath="$3"

  mv "${fullFilePath}" "${tmpFilePath}"
  # append data from previous try
  if [ -f "${tmpFailedPath}" ]; then
    cat "${tmpFailedPath}" >> "${tmpFilePath}"
    rm -f "${tmpFailedPath}"
  fi

  return 0
}

do_rsync() {
  local tmpFilePath="$1"
  local rsyncTarget="$2"
  local tmpFailedPath="$3"

  log "Rsync ${tmpFilePath} to ${rsyncTarget}"

  rsync $RSYNC_FLAGS "${tmpFilePath}" "${rsyncTarget}"
  # save urls if rsync exit code is not successful
  # these urls will be send with the next portion
  local rsyncStatus="$?"
  if [ ${rsyncStatus} -ne 0 ]; then
    mv -f "${tmpFilePath}" "${tmpFailedPath}"
    log "Rsync falied(${rsyncStatus}). Move file to ${tmpFailedPath}"
    failed_rsyncs=$(($failed_rsyncs + 1))
    return 1
  fi
  ok_rsyncs=$(($ok_rsyncs + 1))
  return 0
}

rsync_file() {
  local folder="$1"
  local fileName="$2"
  local rsyncTarget="$3"
  local rsyncPassword="$4"
  local secondaryRsyncTarget="$5"
  local secondaryRsyncPassword="$6"
  local thirdRsyncTarget="$7"
  local thirdRsyncPassword="$8"

  local fullFilePath="$1/$2"
  local tmpFilePath="${fullFilePath}${_TMP_EXTENSION}"
  local tmpFailedPath="${fullFilePath}${_TMP_FAILED_EXTENSION}"

  log "Rsync ${fullFilePath}"

  if [ ! -f "${fullFilePath}" ]; then
    log "File not found: ${fullFilePath}"
    return 1
  fi

  prepare_file "${fullFilePath}" "${tmpFilePath}" "${tmpFailedPath}"
  export RSYNC_PASSWORD="$rsyncPassword"
  do_rsync "${tmpFilePath}" "${rsyncTarget}" "${tmpFailedPath}"

  if [ "" != "${secondaryRsyncTarget}" ]; then
    export RSYNC_PASSWORD="$secondaryRsyncPassword"
    do_rsync "${tmpFilePath}" "${secondaryRsyncTarget}" "${tmpFailedPath}"
  fi

  if [ "" != "${thirdRsyncTarget}" ]; then
    export RSYNC_PASSWORD="$thirdRsyncPassword"
    do_rsync "${tmpFilePath}" "${thirdRsyncTarget}" "${tmpFailedPath}"
  fi
}

# sources
SRC_DIR=/var/lib/yandex/webmaster/viewer
SRC2_DIR=/var/lib/yandex/webmaster/periodic

# destinations
TARGET_HOST=lya.search.yandex.net
TARGET_DIR=addurl

WMC_LOG_TARGET_HOST=wmc-admin01d.search.yandex.net
WMC_LOG_TARGET_DIR=wmc-logs

ANTISPAM_TARGET_HOST=wspm.search.yandex.net
ANTISPAM_TARGET_DIR=imp-wmc/addurl

DELURL_ANTISPAM_HOST=wspm3.search.yandex.net
DELURL_ANTISPAM_DIR=imp-wmc/delurl

# options
RSYNC_FLAGS=--temp-dir=tmp

USER=corba
CORBA_RSYNC_PASSWORD="Ooc1mac5"

WMCUSER=wmcuser
WMCUSER_RSYNC_PASSWORD="HJXna28032"

# rsync targets
ADDURL_TARGET_NAME=addurl.webmaster.`hostname -s`.`date "+%s"`.txt
ADDURL_RSYNC_TARGET="$USER@$TARGET_HOST::$TARGET_DIR/$ADDURL_TARGET_NAME"
ADDURL_LOG_ANTISPAM_RSYNC_TARGET="$USER@$ANTISPAM_TARGET_HOST::$ANTISPAM_TARGET_DIR/$ADDURL_TARGET_NAME"
ADDURL_WMC_LOG_RSYNC_TARGET="$WMCUSER@$WMC_LOG_TARGET_HOST::$WMC_LOG_TARGET_DIR/$ADDURL_TARGET_NAME"

DELURL_TARGET_NAME=delurl.`hostname -s`.`date "+%s"`.txt
DELURL_RSYNC_TARGET="$USER@$TARGET_HOST::$TARGET_DIR/$DELURL_TARGET_NAME"
DELURL_ANTISPAM_RSYNC_TARGET="$USER@$DELURL_ANTISPAM_HOST::$DELURL_ANTISPAM_DIR/$DELURL_TARGET_NAME"
DELURL_WMC_LOG_RSYNC_TARGET="$WMCUSER@$WMC_LOG_TARGET_HOST::$WMC_LOG_TARGET_DIR/$DELURL_TARGET_NAME"

#copy urls from viewer
rsync_file "$SRC_DIR" "addurl.txt" "$ADDURL_RSYNC_TARGET" "$CORBA_RSYNC_PASSWORD"
rsync_file "$SRC_DIR" "addurl-log.txt" "$ADDURL_LOG_ANTISPAM_RSYNC_TARGET" "$CORBA_RSYNC_PASSWORD" "$ADDURL_WMC_LOG_RSYNC_TARGET" "$WMCUSER_RSYNC_PASSWORD"

rsync_file "$SRC_DIR" "delurl.txt" "$DELURL_RSYNC_TARGET" "$CORBA_RSYNC_PASSWORD" "$DELURL_ANTISPAM_RSYNC_TARGET" "$CORBA_RSYNC_PASSWORD"
rsync_file "$SRC_DIR" "delurl-log.txt" "$DELURL_WMC_LOG_RSYNC_TARGET" "$WMCUSER_RSYNC_PASSWORD"

#copy urls from periodic
# generate target names with new date
sleep 10

ADDURL_TARGET_NAME=addurl.webmaster.`hostname -s`.`date "+%s"`.txt
ADDURL_RSYNC_TARGET="$USER@$TARGET_HOST::$TARGET_DIR/$ADDURL_TARGET_NAME"
ADDURL_LOG_ANTISPAM_RSYNC_TARGET="$USER@$ANTISPAM_TARGET_HOST::$ANTISPAM_TARGET_DIR/$ADDURL_TARGET_NAME"
ADDURL_WMC_LOG_RSYNC_TARGET="$WMCUSER@$WMC_LOG_TARGET_HOST::$WMC_LOG_TARGET_DIR/$ADDURL_TARGET_NAME"

DELURL_TARGET_NAME=delurl.`hostname -s`.`date "+%s"`.txt
DELURL_RSYNC_TARGET="$USER@$TARGET_HOST::$TARGET_DIR/$DELURL_TARGET_NAME"
DELURL_ANTISPAM_RSYNC_TARGET="$USER@$DELURL_ANTISPAM_HOST::$DELURL_ANTISPAM_DIR/$DELURL_TARGET_NAME"
DELURL_WMC_LOG_RSYNC_TARGET="$WMCUSER@$WMC_LOG_TARGET_HOST::$WMC_LOG_TARGET_DIR/$DELURL_TARGET_NAME"

rsync_file "$SRC2_DIR" "addurl.txt" "$ADDURL_RSYNC_TARGET" "$CORBA_RSYNC_PASSWORD"
rsync_file "$SRC2_DIR" "addurl-log.txt" "$ADDURL_LOG_ANTISPAM_RSYNC_TARGET" "$CORBA_RSYNC_PASSWORD" "$ADDURL_WMC_LOG_RSYNC_TARGET" "$WMCUSER_RSYNC_PASSWORD"

rsync_file "$SRC2_DIR" "delurl.txt" "$DELURL_RSYNC_TARGET" "$CORBA_RSYNC_PASSWORD" "$DELURL_ANTISPAM_RSYNC_TARGET" "$CORBA_RSYNC_PASSWORD"
rsync_file "$SRC2_DIR" "delurl-log.txt" "$DELURL_WMC_LOG_RSYNC_TARGET" "$WMCUSER_RSYNC_PASSWORD"

log "Task finished"
log "statistics: success=${ok_rsyncs} error=${failed_rsyncs}"
