<?xml version="1.0" encoding="windows-1251"?>

<!DOCTYPE xsl:stylesheet [
	<!ENTITY quot "&#34;">
	<!ENTITY laquo "&#171;">
	<!ENTITY raquo "&#187;">
	<!ENTITY nbsp "&#160;">
	<!ENTITY copy "&#169;">
]>

<xsl:stylesheet 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
xmlns:math="http://exslt.org/math"
xmlns:date="http://exslt.org/dates-and-times"
exclude-result-prefixes="date math"
>
<xsl:output method="html" encoding="utf-8" indent="yes" omit-xml-declaration="yes" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />

<xsl:variable name="current_year" select="date:year()"/>
<xsl:variable name="rnd"><xsl:value-of select="substring( math:random(), 3, 1)"/></xsl:variable>
<xsl:variable name="banner" select="/page404/real_banner/place/banner" /> 
<xsl:variable name="pagename">
	<xsl:choose>
		<xsl:when test="$rnd = 1 or $rnd = 2 or $rnd = 3 ">404black.xhtml</xsl:when>
		<xsl:when test="$rnd = 4 ">404pink.xhtml</xsl:when>
		<xsl:otherwise>404gray.xhtml</xsl:otherwise>
	</xsl:choose>
</xsl:variable>

<xsl:variable name="rndpage" select="document( $pagename )/html" />

<!-- ***********************************************  -->
<xsl:template match="/">
	<xsl:apply-templates select="$rndpage"/>
</xsl:template>

<!-- identity transform -->
<xsl:template match="@*|node()">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()"/>
			</xsl:copy>
</xsl:template>

<xsl:template match="banner">
<xsl:value-of select="$banner" disable-output-escaping="yes"/>
</xsl:template>

<xsl:template match="current_year">
<xsl:value-of select="$current_year"/>
</xsl:template>


</xsl:stylesheet>
