<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
	<!ENTITY copy "&#169;">
    <!ENTITY laquo "&#171;">
    <!ENTITY raquo "&#187;">
]>
<xsl:stylesheet
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:x="http://www.yandex.ru/xscript"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    exclude-result-prefixes="x"
    extension-element-prefixes="date"
    version="1.0">

    <xsl:output method="x:xhtml" encoding="utf-8" indent="no" doctype-public="-//WAPFORUM//DTD XHTML Mobile 1.0//EN" doctype-system="http://www.wapforum.org/DTD/xhtml-mobile10.dtd" omit-xml-declaration="yes"/>

    <!-- Определяем устройство -->
    <xsl:variable name="device-class" select="/page/model/attr[@name = 'device_class']/@value"/>
    <xsl:variable name="device-is-iphone" select="boolean($device-class = 'iphoneos')"/>
    <xsl:variable name="device-is-android" select="boolean($device-class = 'android')"/>

    <!-- Общий шаблон страницы -->
    <xsl:template match="/">
        <html>
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
                <title>404</title>
                <link rel="shortcut icon" href="//yandex.st/lego/_/t4d4dFtFijC7wKwJFRYjUNKV1A0.ico"/>
                <xsl:if test="$device-is-iphone">
                    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0"/>
                </xsl:if>
                <xsl:apply-templates select="page/css"/>
            </head>
            <xsl:apply-templates select="page" mode="body"/>
        </html>
    </xsl:template>

    <!-- Стили CSS -->
    <xsl:template match="css">
        <style type="text/css" media="screen, handheld">
            <xsl:value-of select="." disable-output-escaping="yes"/>
        </style>
    </xsl:template>

    <!-- Тело страницы -->
    <xsl:template match="page" mode="body">
        <body>
            <xsl:if test="$device-is-iphone">
                <xsl:attribute name="class">iphone</xsl:attribute>
                <xsl:attribute name="onload">setTimeout(function(){scrollTo(0, 1)}, 1)</xsl:attribute>
            </xsl:if>
            <xsl:if test="$device-is-android">
                <xsl:attribute name="class">android</xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="." mode="header"/>
            <div class="b-content">
                <xsl:apply-templates select="." mode="content"/>
            </div>
            <xsl:apply-templates select="." mode="footer"/>
        </body>
    </xsl:template>

    <!-- Шапка -->
    <xsl:template match="page" mode="header">
        <table cellspacing="0" cellpadding="0" class="b-head">
            <tr>
                <td class="b-head__logo">
                    <a href="http://www.yandex.ru" class="b-head__logo-link">
                        <img src="http://img.yandex.net/i/m_logo.png" alt="Яндекс" class="b-head__logo-img"/>
                    </a>
                </td>
                <td class="b-head__name">
                    <strong class="b-head__name-desc">404</strong>
                </td>
            </tr>
        </table>
    </xsl:template>

    <!-- Содержимое страницы -->
    <xsl:template match="page" mode="content">
        <h1 class="b-title">Несуществующая страница</h1>
        <div class="b-text">
            <p>Страница, которую вы&nbsp;читаете, не&nbsp;существует.</p>
            <p>Если вы&nbsp;считаете, что мы&nbsp;завели вас сюда специально, опубликовав неверную ссылку, пришлите нам эту ссылку по&nbsp;адресу <a href="mailto:404@yandex-team.ru?subject=404">404@yandex-team.ru</a>.</p>
            <p>А если вы&nbsp;действительно хотите что-то найти в&nbsp;интернете, воспользуйтесь настоящим поиском Яндекса:</p>
        </div>
        <xsl:apply-templates select="." mode="search-form"/>
    </xsl:template>

    <!-- Форма поиска -->
    <xsl:template match="page" mode="search-form">
        <form class="h-search" action="http://yandex.ru/msearch" method="get">
            <div class="b-search">
                <table class="b-search__layout" cellspacing="0" cellpadding="0">
                    <tr>
                        <td class="b-search__layout-l">
                            <div class="b-form-input">
                                <input class="b-form-input__input" name="text"/>
                            </div>
                        </td>
                        <td class="b-search__layout-r">
                            <input class="b-search__button" type="submit" value="Найти"/>
                        </td>
                    </tr>
                </table>
            </div>
        </form>
    </xsl:template>

    <!-- Подвал -->
    <xsl:template match="page" mode="footer">
        <div class="b-foot">
            <p class="b-foot__copyright">&copy;&nbsp;<xsl:value-of select="date:year()"/> &laquo;<a href="http://www.yandex.ru">Яндекс</a>&raquo;</p>
            <p class="b-foot__info">
                <a href="http://mobile-feedback.yandex.ru/?from=404">Обратная связь</a>
            </p>
        </div>
    </xsl:template>

</xsl:stylesheet>
