#!/bin/bash

SRC_DIR=/var/lib/yandex/webmaster/wmc-logs
TOOLS="addurl delurl crawlurl rewriteurl reindexurl"
TOTAL_SUFFIX=.total
TEMP_TOTAL_SUFFIX=$TOTAL_SUFFIX.tmp

shopt -s nullglob

cd "$SRC_DIR"
for tool in $TOOLS
do
  > $SRC_DIR/$tool$TEMP_TOTAL_SUFFIX
  for file in $SRC_DIR/$tool.*.*.txt
  do
    cat $file >> $SRC_DIR/$tool$TEMP_TOTAL_SUFFIX
  done
  rm -f $SRC_DIR/$tool$TOTAL_SUFFIX
  mv -f $SRC_DIR/$tool$TEMP_TOTAL_SUFFIX $SRC_DIR/$tool$TOTAL_SUFFIX
done

find $SRC_DIR -mtime +32 -name "addurl.*.*.txt" -or \
              -mtime +32 -name "delurl.*.*.txt" -or \
              -mtime +32 -name "crawlurl.*.*.txt" -or \
              -mtime +32 -name "rewriteurl.*.*.txt" -or \
              -mtime +32 -name "reindexurl.*.*.txt" | xargs -n 100 rm -f
